exports.getTemplate = (type, data = {}) => {
  const { user, application, document, awardLetterUrl, queryResponse } = data;

  switch (type) {
    case 'registration':
      return {
        subject: `🎉 Welcome to EMTAF, ${user.fullName}!`,
        html: `
          <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
            <h2 style="color: #2c3e50;">Hello ${user.fullName},</h2>
            <p style="font-size: 16px; line-height: 1.5;">Congratulations on joining the EMTAF Bursary Portal! Your account has been successfully created, and you're now ready to take the next step toward securing your bursary.</p>
            <p style="font-size: 16px; line-height: 1.5;">Log in to your account to start your application and explore the opportunities awaiting you.</p>
            <a href="https://emtaf-portal.com/login" style="display: inline-block; padding: 10px 20px; background-color: #3498db; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px;">Start Your Application</a>
            <p style="font-size: 14px; color: #7f8c8d; margin-top: 20px;">If you have any questions, our support team is here to help at support@emtaf.org.</p>
          </div>
        `,
      };

    case 'applicationSubmitted':
      return {
        subject: '📄 Your Bursary Application Has Been Submitted',
        html: `
          <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
            <h2 style="color: #2c3e50;">Application Successfully Submitted</h2>
            <p style="font-size: 16px; line-height: 1.5;">Thank you for submitting your bursary application to EMTAF. We have received your application, and it is now under review.</p>
            <p style="font-size: 16px;"><strong>Reference Number:</strong> ${application.refNumber}</p>
            <p style="font-size: 16px;"><strong>Status:</strong> <span style="color: orange;">Pending</span></p>
            <p style="font-size: 16px; line-height: 1.5;">You can track the progress of your application by logging into the EMTAF Bursary Portal. We’ll notify you once a decision has been made.</p>
            <a href="https://emtaf-portal.com/login" style="display: inline-block; padding: 10px 20px; background-color: #3498db; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px;">Check Application Status</a>
          </div>
        `,
      };

    case 'documentUploaded':
      return {
        subject: `📎 New Document Uploaded: ${document.type}`,
        html: `
          <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
            <h2 style="color: #2c3e50;">Document Successfully Uploaded</h2>
            <p style="font-size: 16px; line-height: 1.5;">We’ve received the document you uploaded to the EMTAF Bursary Portal.</p>
            <p style="font-size: 16px;"><strong>Document Type:</strong> ${document.type}</p>
            <p style="font-size: 16px;"><strong>File Name:</strong> ${document.originalName}</p>
            <p style="font-size: 16px; line-height: 1.5;">This document has been added to your application. You can review or upload additional documents by logging into your account.</p>
            <a href="https://emtaf-portal.com/login" style="display: inline-block; padding: 10px 20px; background-color: #3498db; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px;">View Your Documents</a>
          </div>
        `,
      };

    case 'applicationApproved':
      return {
        subject: '✅ Congratulations! Your Bursary Application is Approved',
        html: `
          <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
            <h2 style="color: #2c3e50;">Congratulations, ${user.fullName}! 🎓</h2>
            <p style="font-size: 16px; line-height: 1.5;">We’re thrilled to inform you that your bursary application (Reference: ${application.refNumber}) has been <strong>approved</strong>!</p>
            <p style="font-size: 16px; line-height: 1.5;">This is a significant step toward achieving your educational goals. You’ll receive further details about the next steps, including your award letter, soon.</p>
            <a href="https://emtaf-portal.com/login" style="display: inline-block; padding: 10px 20px; background-color: #3498db; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px;">Log In to Your Account</a>
            <p style="font-size: 14px; color: #7f8c8d; margin-top: 20px;">For any questions, contact our team at support@emtaf.org.</p>
          </div>
        `,
      };

    case 'applicationRejected':
      return {
        subject: '❌ Update on Your Bursary Application',
        html: `
          <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
            <h2 style="color: #2c3e50;">Hello ${user.fullName},</h2>
            <p style="font-size: 16px; line-height: 1.5;">We regret to inform you that your bursary application (Reference: ${application.refNumber}) was not successful this time.</p>
            <p style="font-size: 16px; line-height: 1.5;">If you believe this decision was made in error, you may lodge a dispute within 14 days by logging into the EMTAF Bursary Portal.</p>
            <a href="https://emtaf-portal.com/dispute" style="display: inline-block; padding: 10px 20px; background-color: #3498db; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px;">Lodge a Dispute</a>
            <p style="font-size: 14px; color: #7f8c8d; margin-top: 20px;">We appreciate your effort and encourage you to explore other opportunities on our portal.</p>
          </div>
        `,
      };

    case 'awardLetterIssued':
      return {
        subject: '🧾 Your Bursary Award Letter is Ready',
        html: `
          <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
            <h2 style="color: #2c3e50;">Dear ${user.fullName},</h2>
            <p style="font-size: 16px; line-height: 1.5;">We’re excited to share that your bursary award letter is now available for download.</p>
            <p style="font-size: 16px; line-height: 1.5;">This document outlines the details of your bursary award. Please review it carefully and contact us if you have any questions.</p>
            <a href="${awardLetterUrl}" style="display: inline-block; padding: 10px 20px; background-color: #3498db; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px;" target="_blank">Download Your Award Letter</a>
            <p style="font-size: 14px; color: #7f8c8d; margin-top: 20px;">For support, reach out to us at support@emtaf.org.</p>
          </div>
        `,
      };

    case 'passwordChanged':
      return {
        subject: '🔐 Your Password Has Been Updated',
        html: `
          <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
            <h2 style="color: #2c3e50;">Hello ${user.fullName},</h2>
            <p style="font-size: 16px; line-height: 1.5;">This is a confirmation that your EMTAF Bursary Portal account password has been successfully updated.</p>
            <p style="font-size: 16px; line-height: 1.5;">If you did not initiate this change, please contact our support team immediately at support@emtaf.org.</p>
            <a href="https://emtaf-portal.com/login" style="display: inline-block; padding: 10px 20px; background-color: #3498db; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px;">Log In to Your Account</a>
          </div>
        `,
      };

    case 'queryResponse':
      return {
        subject: '🗨️ Response to Your Query',
        html: `
          <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
            <h2 style="color: #2c3e50;">Hello ${user.fullName},</h2>
            <p style="font-size: 16px; line-height: 1.5;">Thank you for reaching out to us. Below is our response to your query:</p>
            <blockquote style="border-left: 4px solid #3498db; padding-left: 15px; font-size: 16px; line-height: 1.5; color: #2c3e50;">${queryResponse}</blockquote>
            <p style="font-size: 16px; line-height: 1.5;">If you have further questions, feel free to submit another query through the EMTAF Bursary Portal.</p>
            <a href="https://emtaf-portal.com/support" style="display: inline-block; padding: 10px 20px; background-color: #3498db; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px;">Contact Support</a>
          </div>
        `,
      };

    case 'resetPassword':
      return {
        subject: '🔑 Reset Your EMTAF Bursary Portal Password',
        html: `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
        <h2 style="color: #2c3e50;">Hi ${user.fullName},</h2>
        <p style="font-size: 16px; line-height: 1.5;">
          You recently requested to reset your password for your EMTAF Bursary Portal account.
        </p>
        <p style="font-size: 16px; line-height: 1.5;">
          Click the button below to set a new password. This link will expire in 15 minutes.
        </p>
        <a href="https://emtaf-portal.com/reset-password?token=${resetToken}"
           style="display: inline-block; padding: 12px 24px; background-color: #3498db; color: white;
           text-decoration: none; border-radius: 5px; margin-top: 15px;">
          Reset Password
        </a>
        <p style="font-size: 14px; margin-top: 20px; color: #7f8c8d;">
          If you did not request this, you can safely ignore this email.
        </p>
      </div>
    `
      };

    default:
      return {
        subject: 'Notification from EMTAF',
        html: `
          <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px;">
            <h2 style="color: #2c3e50;">Hello,</h2>
            <p style="font-size: 16px; line-height: 1.5;">This is a general notification from the EMTAF Bursary Portal.</p>
            <p style="font-size: 16px; line-height: 1.5;">Please log in to your account for more details or contact our support team at support@emtaf.org.</p>
            <a href="https://emtaf-portal.com/login" style="display: inline-block; padding: 10px 20px; background-color: #3498db; color: white; text-decoration: none; border-radius: 5px; margin-top: 15px;">Log In to Your Account</a>
          </div>
        `,
      };
  }
};