const express = require('express');
const router = express.Router();
const { getProfile, updateProfile } = require('../controllers/userController');
const { changePassword } = require('../controllers/userController');
const authMiddleware = require('../middlewares/authMiddleware');
const restrictTo = require('../middlewares/restrictTo');
const { getAllStudents } = require('../controllers/userController');


router.get('/profile', authMiddleware, getProfile);
router.put('/profile', authMiddleware, updateProfile);
router.post('/change-password', authMiddleware, changePassword);
router.get('/', authMiddleware, restrictTo('admin', 'systemAdmin'), getAllStudents);

module.exports = router;
