const express = require('express');
const router = express.Router();
const upload = require('../middlewares/uploadMiddleware');
const authMiddleware = require('../middlewares/authMiddleware');
const {
    uploadDocument,
    getDocumentsByApplication,
    deleteDocument,
} = require('../controllers/documentController');

router.post(
    '/upload',
    authMiddleware,
    upload.single('document'),
    uploadDocument
);

router.get('/:applicationId', authMiddleware, getDocumentsByApplication);
router.delete('/:documentId', authMiddleware, deleteDocument);

module.exports = router;
