const express = require('express');
const router = express.Router();
const controller = require('../controllers/bursaryController');
const auth = require('../middlewares/authMiddleware');
const role = require('../middlewares/roleMiddleware'); // optional

router.post('/', auth, /* role('admin'), */ controller.createBursary);
router.get('/', auth, controller.getAllBursaries);
router.get('/:id', auth, controller.getBursaryById);
router.put('/:id', auth, /* role('admin'), */ controller.updateBursary);
router.delete('/:id', auth, /* role('admin'), */ controller.deleteBursary);

module.exports = router;
