const express = require('express');
const router = express.Router();
const { applyForBursary, getMyApplications, getApplicationByRef } = require('../controllers/applicationController');
const authMiddleware = require('../middlewares/authMiddleware');

router.post('/', authMiddleware, applyForBursary);
router.get('/', authMiddleware, getMyApplications);
router.get('/ref/:refNumber', authMiddleware, getApplicationByRef);

module.exports = router;
