const mongoose = require('mongoose');

const volunteerReportSchema = new mongoose.Schema(
    {
        userId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'User',
            required: [true, 'User ID is required'],
            index: true,
        },
        activity: {
            type: String,
            required: [true, 'Activity description is required'],
            trim: true,
        },
        hours: {
            type: Number,
            required: [true, 'Hours are required'],
            min: [0, 'Hours cannot be negative'],
        },
        reportDate: {
            type: Date,
            default: Date.now,
        },
        reportFilePath: {
            type: String,
        },
    },
    { timestamps: true }
);

volunteerReportSchema.index({ userId: 1, reportDate: 1 });

module.exports = mongoose.model('VolunteerReport', volunteerReportSchema);