const mongoose = require('mongoose');

const visitScheduleSchema = new mongoose.Schema(
    {
        userId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'User',
            required: [true, 'User ID is required'],
            index: true,
        },
        date: {
            type: Date,
            required: [true, 'Visit date is required'],
        },
        location: {
            type: String,
            required: [true, 'Location is required'],
            trim: true,
        },
        purpose: {
            type: String,
            required: [true, 'Purpose is required'],
            trim: true,
        },
        status: {
            type: String,
            enum: ['scheduled', 'completed', 'cancelled'],
            default: 'scheduled',
        },
    },
    { timestamps: true }
);

visitScheduleSchema.index({ userId: 1, date: 1 });

module.exports = mongoose.model('VisitSchedule', visitScheduleSchema);