const mongoose = require('mongoose');

const stakeholderMeetingSchema = new mongoose.Schema(
    {
        date: {
            type: Date,
            required: [true, 'Meeting date is required'],
        },
        participants: [
            {
                type: mongoose.Schema.Types.ObjectId,
                ref: 'User',
            },
        ],
        agenda: {
            type: String,
            required: [true, 'Agenda is required'],
            trim: true,
        },
        minutesFilePath: {
            type: String,
        },
        outcome: {
            type: String,
            trim: true,
        },
    },
    { timestamps: true }
);

stakeholderMeetingSchema.index({ date: 1 });

module.exports = mongoose.model('StakeholderMeeting', stakeholderMeetingSchema);