const mongoose = require('mongoose');

const reportLogSchema = new mongoose.Schema(
    {
        userId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'User',
            required: [true, 'User ID is required'],
            index: true,
        },
        reportType: {
            type: String,
            enum: [
                'recipient_expenditure',
                'applications',
                'qualification_level',
                'demographic',
                'queries',
                'graduation',
                'total_cost',
            ],
            required: [true, 'Report type is required'],
        },
        parameters: {
            type: Object, // Store query parameters (e.g., date range, filters)
        },
        filePath: {
            type: String, // Path to exported report file (if applicable)
        },
        generatedAt: {
            type: Date,
            default: Date.now,
        },
    },
    { timestamps: true }
);

reportLogSchema.index({ userId: 1, reportType: 1, generatedAt: 1 });

module.exports = mongoose.model('ReportLog', reportLogSchema);