const mongoose = require('mongoose');

const querySchema = new mongoose.Schema(
    {
        applicationId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'Application',
            required: [true, 'Application ID is required'],
            index: true,
        },
        userId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'User',
            required: [true, 'User ID is required'],
        },
        type: {
            type: String,
            enum: ['query', 'appeal'],
            required: [true, 'Query type is required'],
        },
        description: {
            type: String,
            required: [true, 'Description is required'],
            trim: true,
        },
        status: {
            type: String,
            enum: ['open', 'resolved', 'closed'],
            default: 'open',
        },
        response: {
            type: String,
            trim: true,
        },
        responseDate: {
            type: Date,
        },
    },
    { timestamps: true }
);

querySchema.index({ applicationId: 1, status: 1 });

module.exports = mongoose.model('Query', querySchema);