const mongoose = require('mongoose');

const placementSchema = new mongoose.Schema(
    {
        userId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'User',
            required: [true, 'User ID is required'],
            index: true,
        },
        organization: {
            type: String,
            required: [true, 'Organization name is required'],
            trim: true,
        },
        role: {
            type: String,
            required: [true, 'Role is required'],
            trim: true,
        },
        startDate: {
            type: Date,
            required: [true, 'Start date is required'],
        },
        endDate: {
            type: Date,
        },
        status: {
            type: String,
            enum: ['active', 'completed', 'terminated'],
            default: 'active',
        },
    },
    { timestamps: true }
);

placementSchema.index({ userId: 1, startDate: 1 });

module.exports = mongoose.model('Placement', placementSchema);