const mongoose = require('mongoose');

const paymentSchema = new mongoose.Schema(
    {
        applicationId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'Application',
            required: [true, 'Application ID is required'],
            index: true,
        },
        userId: {
            type: mongoose.Schema.Types.ObjectId,
            ref: 'User',
            required: [true, 'User ID is required'],
        },
        institution: {
            type: String,
            required: [true, 'Institution name is required'],
            trim: true,
        },
        amount: {
            type: Number,
            required: [true, 'Payment amount is required'],
            min: [0, 'Amount cannot be negative'],
        },
        invoiceFilePath: {
            type: String,
        },
        proofOfPaymentFilePath: {
            type: String,
        },
        status: {
            type: String,
            enum: ['pending', 'requested', 'authorized', 'paid', 'failed'],
            default: 'pending',
        },
        paymentDate: {
            type: Date,
        },
    },
    { timestamps: true }
);

paymentSchema.index({ applicationId: 1, status: 1 });

module.exports = mongoose.model('Payment', paymentSchema);