const { DataTypes } = require('sequelize');
const sequelize = require('../config/db');
const Application = require('./Application');

const Bursary = sequelize.define('Bursary', {
    id: {
        type: DataTypes.UUID,
        defaultValue: DataTypes.UUIDV4,
        primaryKey: true,
    },
    title: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    description: {
        type: DataTypes.TEXT,
    },
    academicYear: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    institution: {
        type: DataTypes.STRING,
    },
    qualification: {
        type: DataTypes.STRING,
    },
    maxAmount: {
        type: DataTypes.FLOAT,
    },
    applicationDeadline: {
        type: DataTypes.DATE,
    },
    createdBy: {
        type: DataTypes.UUID,
        allowNull: true,
    },
}, {
    timestamps: true,
});

// 🧩 Setup direct relationship here
Bursary.hasMany(Application, { foreignKey: 'bursaryId', onDelete: 'CASCADE' });
Application.belongsTo(Bursary, { foreignKey: 'bursaryId' });

module.exports = Bursary;
