const { DataTypes } = require('sequelize');
const sequelize = require('../config/db');
const User = require('./User');

const Application = sequelize.define('Application', {
    id: {
        type: DataTypes.UUID,
        defaultValue: DataTypes.UUIDV4,
        primaryKey: true,
    },
    refNumber: {
        type: DataTypes.STRING,
        allowNull: true,
        unique: true,
    },
    status: {
        type: DataTypes.ENUM('pending', 'approved', 'rejected'),
        defaultValue: 'pending',
    },
    qualification: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    institution: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    tuitionFee: {
        type: DataTypes.FLOAT,
        allowNull: false,
    },
    bookFee: {
        type: DataTypes.FLOAT,
        allowNull: false,
    },
    accommodationFee: {
        type: DataTypes.FLOAT,
        allowNull: false,
    },
    totalRequested: {
        type: DataTypes.FLOAT,
        allowNull: false,
    },
    bursaryId: {
        type: DataTypes.UUID,
        allowNull: false,
        references: {
            model: 'Bursaries',
            key: 'id',
        },
    },

    // 🔽 NEW FIELDS BELOW
    motivation: {
        type: DataTypes.TEXT,
        allowNull: true,
    },
    yearOfStudy: {
        type: DataTypes.INTEGER,
        allowNull: true,
    },
    academicYear: {
        type: DataTypes.INTEGER,
        allowNull: true,
    },
    applicationSource: {
        type: DataTypes.ENUM('online', 'manual'),
        defaultValue: 'online',
    },
    supportingDocsStatus: {
        type: DataTypes.ENUM('valid', 'incomplete', 'pending'),
        defaultValue: 'pending',
    },
    institutionType: {
        type: DataTypes.ENUM('public', 'private'),
        allowNull: true,
    },
    studentType: {
        type: DataTypes.ENUM('new', 'returning'),
        allowNull: true,
    },
    disabilityStatus: {
        type: DataTypes.BOOLEAN,
        defaultValue: false,
    },
    applicationStage: {
        type: DataTypes.ENUM('submitted', 'review', 'interview', 'decision'),
        defaultValue: 'submitted',
    },
    decisionDate: {
        type: DataTypes.DATE,
        allowNull: true,
    },
    adjudicatedBy: {
        type: DataTypes.UUID,
        allowNull: true,
    },
    interviewScore: {
        type: DataTypes.FLOAT,
        allowNull: true,
    }
}, {
    timestamps: true,
});

User.hasMany(Application, { foreignKey: 'userId' });
Application.belongsTo(User, { foreignKey: 'userId' });

module.exports = Application;
