const jwt = require('jsonwebtoken');
const User = require('../models/User');

const authMiddleware = async (req, res, next) => {
    const authHeader = req.headers.authorization;

    if (!authHeader || !authHeader.startsWith('Bearer ')) {
        return res.status(401).json({ message: 'Missing or invalid token' });
    }

    const token = authHeader.split(' ')[1];

    try {
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const user = await User.findByPk(decoded.id);
        if (!user) throw new Error('User not found');

        req.user = user; // Attach user to request
        next();
    } catch (error) {
        console.error('JWT Error:', error);
        res.status(403).json({ message: 'Invalid or expired token' });
    }
};

module.exports = authMiddleware;
