const User = require('../models/User');
const bcrypt = require('bcryptjs');


// 🔹 GET current profile
exports.getProfile = async (req, res) => {
    try {
        const user = await User.findByPk(req.user.id, {
            attributes: { exclude: ['password'] },
        });
        res.json(user);
    } catch (err) {
        console.error('❌ Get profile error:', err);
        res.status(500).json({ message: 'Server error' });
    }
};

// 🔹 UPDATE profile
exports.updateProfile = async (req, res) => {
    try {
        const userId = req.user.id;
        const updates = req.body;

        await User.update(updates, { where: { id: userId } });
        const updatedUser = await User.findByPk(userId, {
            attributes: { exclude: ['password'] },
        });

        res.json({ message: 'Profile updated', user: updatedUser });
    } catch (err) {
        console.error('❌ Update profile error:', err);
        res.status(500).json({ message: 'Server error' });
    }
};

exports.changePassword = async (req, res) => {
    try {
        const user = await User.findByPk(req.user.id);

        const { currentPassword, newPassword } = req.body;

        const isMatch = await user.comparePassword(currentPassword);
        if (!isMatch) {
            return res.status(400).json({ message: 'Current password is incorrect' });
        }

        const hashed = await bcrypt.hash(newPassword, 10);
        user.password = hashed;
        await user.save();

        res.json({ message: 'Password updated successfully' });
    } catch (err) {
        console.error('❌ Change password error:', err);
        res.status(500).json({ message: 'Server error' });
    }
};

exports.getAllStudents = async (req, res) => {
    try {
        const students = await User.findAll({
            where: { role: 'student' },
            attributes: { exclude: ['password'] },
        });
        res.json(students);
    } catch (err) {
        console.error('❌ Get students error:', err);
        res.status(500).json({ message: 'Server error' });
    }
};
