const { createControllerErrorHandler, throwAPIError } = require('../../utils/errorHandler');
const AcademicReport = require('../../models/AcademicReport');
const VisitSchedule = require('../../models/VisitSchedule');
const User = require('../../models/User');


const handleError = createControllerErrorHandler('AdminStudentMonitoringController');

const createAcademicReport = async (req, res, next) => {
    try {
        const { userId, academicYear, institution, grades, reportFilePath } = req.body;
        const user = await User.findById(userId);
        if (!user || user.role !== 'student') throwAPIError(404, 'Student not found');

        const report = await AcademicReport.create({
            userId,
            academicYear,
            institution,
            grades,
            reportFilePath,
        });

        res.status(201).json({
            status: 'success',
            data: { report },
        });
    } catch (error) {
        next(handleError(error));
    }
};

const scheduleVisit = async (req, res, next) => {
    try {
        const { userId, date, location, purpose } = req.body;
        const user = await User.findById(userId);
        if (!user || user.role !== 'student') throwAPIError(404, 'Student not found');

        const visit = await VisitSchedule.create({
            userId,
            date,
            location,
            purpose,
        });

        res.status(201).json({
            status: 'success',
            data: { visit },
        });
    } catch (error) {
        next(handleError(error));
    }
};

module.exports = { createAcademicReport, scheduleVisit };