const { createControllerErrorHandler, throwAPIError } = require('../../utils/errorHandler');
const ReportLog = require('../../models/ReportLog');
const Application = require('../../models/Application');

const handleError = createControllerErrorHandler('AdminReportController');

const generateReport = async (req, res, next) => {
    try {
        const { reportType, parameters } = req.body;
        const validTypes = [
            'recipient_expenditure',
            'applications',
            'qualification_level',
            'demographic',
            'queries',
            'graduation',
            'total_cost',
        ];
        if (!validTypes.includes(reportType)) throwAPIError(400, 'Invalid report type');

        // Example: Generate applications report
        let data;
        if (reportType === 'applications') {
            const query = parameters.status ? { status: parameters.status } : {};
            data = await Application.find(query).populate('userId', 'firstName lastName');
        } else {
            // Placeholder for other report types
            data = [];
        }

        const report = await ReportLog.create({
            userId: req.user._id,
            reportType,
            parameters,
            generatedAt: Date.now(),
        });

        res.status(200).json({
            status: 'success',
            data: { report, data },
        });
    } catch (error) {
        next(handleError(error));
    }
};

module.exports = { generateReport };