const { Application } = require('../models/Application');
const { sendEmailWithTemplate } = require('../utils/email');

exports.adjudicateApplication = async (req, res) => {
    try {
        const { status, interviewScore } = req.body;
        const { id } = req.params;
        const adjudicatedBy = req.user.id;

        if (!['approved', 'rejected'].includes(status)) {
            return res.status(400).json({ message: 'Status must be approved or rejected' });
        }

        const application = await Application.findByPk(id);
        if (!application) {
            return res.status(404).json({ message: 'Application not found' });
        }

        // Update fields
        application.status = status;
        application.applicationStage = 'decision';
        application.interviewScore = interviewScore || null;
        application.adjudicatedBy = adjudicatedBy;
        application.decisionDate = new Date();

        await application.save();

        // Get linked user and notify
        const user = await application.getUser();
        if (user?.email) {
            const templateName = status === 'approved' ? 'applicationApproved' : 'applicationRejected';
            await sendEmailWithTemplate({
                to: user.email,
                templateName,
                data: {
                    user,
                    application,
                },
            });
        }

        res.status(200).json({
            message: `Application ${status}`,
            application,
        });
    } catch (err) {
        console.error('❌ Adjudication error:', err);
        res.status(500).json({ message: 'Internal Server Error' });
    }
};
