const express = require('express');
const cors = require('cors');
const app = express();

require('dotenv').config();

app.use(cors());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// ROUTES
app.use('/api/v1/auth', require('./routes/authRoutes'));
app.use('/api/v1/applications', require('./routes/applicationRoutes'));
// app.use('/api/v1/bursaries', require('./routes/bursaryRoutes'));
// app.use('/api/v1/queries', require('./routes/queryRoutes'));
// app.use('/api/v1/payments', require('./routes/paymentRoutes'));
// app.use('/api/v1/monitoring', require('./routes/monitoringRoutes'));
// app.use('/api/v1/reports', require('./routes/reportRoutes'));
app.use('/api/v1/documents', require('./routes/documentRoutes'));
app.use('/api/v1/users', require('./routes/userRoutes'));

module.exports = app;
