
# 🎓 EMTAF Bursary Management API

A Node.js + Express.js + MySQL RESTful API for managing the Executive Mayor’s Tertiary Assistance Fund (EMTAF). Supports student applications, document uploads, admin adjudication, and email notifications.

---

## 🚀 Features

- JWT-based authentication
- User registration & login
- Admin + Student role separation
- Apply for bursary tied to a specific bursary
- Document upload & download via Multer
- Admin adjudication (approve/reject)
- Email notifications (via templates)
- View application status by refNumber
- Role-based protection for admin endpoints

---

## 📁 Directory Structure

```
📦emtaf-api
 ┣ 📂controllers
 ┣ 📂models
 ┣ 📂routes
 ┣ 📂utils
 ┣ 📂middleware
 ┣ 📂email
 ┣ 📜server.js
 ┣ 📜.env
```

---

## 🧪 API Endpoints (Postman Collection Available)

### 🔐 Auth

- `POST /api/v1/auth/register`
- `POST /api/v1/auth/login`
- `POST /api/v1/auth/change-password`

### 👤 Users

- `GET /api/v1/users` – Admin list
- `PUT /api/v1/users/profile` – Update

### 🎓 Bursaries (Admin)
- `POST /api/v1/bursaries` – Create bursary
- `GET /api/v1/bursaries` – List all bursaries
- `GET /api/v1/bursaries/:id` – View bursary
- `PUT /api/v1/bursaries/:id` – Update
- `DELETE /api/v1/bursaries/:id` – Delete

### 📝 Applications (Student)

- `POST /api/v1/applications` – Apply to bursary
- `GET /api/v1/applications` – List student applications
- `GET /api/v1/applications/:refNumber` – View by reference

### 📂 Documents

- `POST /api/v1/applications/:id/documents` – Upload docs
- `GET /api/v1/applications/:id/documents` – View uploaded
- `DELETE /api/v1/applications/:id/documents/:fileId` – Delete file

### 🧾 Admin Adjudication

- `PUT /api/v1/applications/:id/adjudicate` – Approve/Reject

---

## 🧠 Bursary Application Flow (Student)

1. **Login/Register**
2. **View bursaries** – `GET /bursaries`
3. **Apply** – `POST /applications` (with `bursaryId`)
4. **Email sent** – applicationSubmitted
5. **Upload supporting docs**
6. **Track status** – `GET /applications`
7. **Adjudication** – Admin approves/rejects
8. **Email sent** – applicationApproved / applicationRejected

---

## 🔧 Tech Stack

- Node.js
- Express.js
- Sequelize ORM + MySQL
- Multer (file upload)
- JWT Auth
- Nodemailer (email)
- AWS S3 (optional)
- Redis (optional caching)
- Bootstrap 5 (Frontend not included here)

---

## 📬 Email Templates

- `registration`
- `applicationSubmitted`
- `applicationApproved`
- `applicationRejected`

All located in `/utils/emailService.js` with dynamic rendering support.

---

## 🧪 Testing

Import the latest [Postman Collection](./EMTAF_Bursary_API_PLUS_BURSARY_ENDPOINTS.postman_collection.json) for all endpoints.

---

## 👥 Roles

- **Student**: Apply, upload, track
- **Admin**: Create bursaries, adjudicate, view all

---

## 🔐 .env Sample

```
APP_PORT=3001
DB_URI=mysql://user:pass@localhost:3306/emtaf_db
JWT_SECRET=your_jwt_secret
EMAIL_USER=admin@bukani-tech.co.za
EMAIL_PASS=xxx
```

---

## 📌 Author

**Sibanye Bukani** – Full Stack API Engineer | CTO in the making 🚀

---
