# 🎓 EMTAF Bursary Management API

This is a backend REST API for the **Executive Mayor’s Tertiary Assistance Fund (EMTAF)** bursary system, designed to manage student registrations, bursary applications, document uploads, application status tracking, queries/disputes, and admin workflows.

## 🚀 Tech Stack

| Layer        | Technology           |
|--------------|----------------------|
| Backend      | Node.js, Express.js  |
| Database     | MySQL + Sequelize    |
| Auth         | JWT                  |
| File Uploads | Multer (local disk)  |
| Email        | Nodemailer + SMTP    |
| Roles        | Student, Admin       |
| Caching      | Redis (optional)     |

## 📁 Project Structure

```
.
├── controllers/
├── models/
├── routes/
├── middlewares/
├── utils/
├── config/
├── uploads/documents/
├── app.js
├── server.js
├── .env
└── README.md
```

## 🛠 Setup Instructions

### 1. Clone and Install
```bash
git clone https://github.com/your-org/emtaf-api.git
cd emtaf-api
npm install
```

### 2. Configure `.env`

```env
APP_PORT=3001
DB_HOST=localhost
DB_USER=root
DB_PASS=yourpassword
DB_NAME=emtaf
JWT_SECRET=supersecure
EMAIL_HOST=mail.bukani-tech.co.za
EMAIL_PORT=465
EMAIL_SECURE=true
EMAIL_USER=admin@bukani-tech.co.za
EMAIL_PASS=your_email_password
EMAIL_SENDER_NAME=EMTAF Bursary Office
EMAIL_FROM=noreply@bukani-tech.co.za
```

### 3. Start the App

```bash
node server.js
```

## 🔐 Authentication

JWT is used for protected routes. Send token via:

```
Authorization: Bearer <token>
```

## 📦 API Endpoints

### 🔑 Auth Routes (`/api/v1/auth`)

| Method | Endpoint        | Description |
|--------|------------------|-------------|
| POST   | `/register`      | Register a student |
| POST   | `/login`         | Login and receive JWT |
| POST   | `/forgot-password` _(optional)_ | Password reset |
| POST   | `/reset-password` _(optional)_  | Reset password with token |

### 👤 User Routes (`/api/v1/users`)

| Method | Endpoint                | Description            |
|--------|--------------------------|------------------------|
| GET    | `/profile`               | Get current user profile |
| PUT    | `/profile`               | Update profile details |
| POST   | `/change-password`       | Change password |
| GET    | `/` _(admin only)_       | List all student users |

### 📄 Application Routes (`/api/v1/applications`)

| Method | Endpoint    | Description |
|--------|-------------|-------------|
| POST   | `/`         | Submit a bursary application |
| GET    | `/`         | _(admin)_ List all applications |
| GET    | `/:id`      | _(admin)_ View one application |
| POST   | `/:id/adjudicate` | _(admin)_ Approve/reject application |

### 📎 Document Routes (`/api/v1/documents`)

| Method | Endpoint                       | Description |
|--------|--------------------------------|-------------|
| POST   | `/upload`                      | Upload document (form-data) |
| GET    | `/:applicationId`              | View uploaded documents |
| DELETE | `/:documentId`                 | Delete a document |

Form-data required:
- `applicationId`
- `type` (e.g. `proof_of_income`)
- `document` (file)

### 📬 Email Notifications

Automatically triggered on:

- ✅ Registration
- ✅ Application submission
- ✅ Document upload
- ✅ Application approval/rejection
- ✅ Award letter issued
- ✅ Password change
- ✅ Query response

Custom email templates defined in `utils/emailTemplates.js`

### 🗨️ Query/Dispute (Planned)

| Method | Endpoint              | Description |
|--------|------------------------|-------------|
| POST   | `/api/v1/queries`     | Submit dispute |
| GET    | `/api/v1/queries`     | _(admin)_ View all |
| POST   | `/api/v1/queries/:id/respond` | _(admin)_ Respond |

## 📂 File Upload Structure

- Files stored in `uploads/documents/`
- Max file size: 2MB
- Allowed formats: PDF, JPEG, PNG

## 🛡️ Role-Based Access Control

| Role     | Capabilities |
|----------|--------------|
| `student` | Apply, upload docs, track status |
| `admin`   | View/approve apps, issue contracts, manage users/queries |

## 📧 Email Preview Example

> _Sent after registration:_

```
Subject: 🎉 Welcome to EMTAF
Body: Hi John, your account was created...
```

## 🧪 Testing Tips

- Use **Postman** or **Thunder Client** to send requests
- Include `Authorization: Bearer <token>` header
- Register a user, log in, and test profile, application, and document routes

## 🔧 To-Do / Coming Features

- [ ] SMS notifications (Twilio)
- [ ] Query/dispute module
- [ ] Admin dashboards
- [ ] Award letter PDF generation
- [ ] Email retries with queue (e.g. BullMQ)

## 📜 License

MIT License

## 👨‍💻 Maintained By

**Sibanye Bukani**  
📧 [admin@bukani-tech.co.za](mailto:admin@bukani-tech.co.za)  
🌍 [bukani-tech.co.za](https://www.bukani-tech.co.za)